/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.world.cap.events;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IWorldEventHandler;
import dev.toma.gunsrpg.common.init.ModSounds;
import dev.toma.gunsrpg.world.cap.events.WorldEventSpec;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class BloodmoonEventHandler
implements IWorldEventHandler {
    private static final ITextComponent TEXT_BLOODMOON_FALL = new TranslationTextComponent("event.bloodmoon.end").func_240699_a_(TextFormatting.GREEN);

    @Override
    public void eventStarted(World world) {
        GunsRPG.log.debug(WorldEventSpec.MARKER, "Sending bloodmoon start notification");
        world.func_217369_A().stream().map(player -> (ServerPlayerEntity)player).forEach(this::notifyBloodmoonStart);
    }

    @Override
    public void eventFinished(World world) {
        GunsRPG.log.debug(WorldEventSpec.MARKER, "Sending bloodmoon end notification");
        world.func_217369_A().stream().map(player -> (ServerPlayerEntity)player).forEach(this::notifyBloodmoonEnd);
    }

    @Override
    public boolean canTriggerEvent(World world) {
        return world.func_72820_D() % 24000L >= 12500L;
    }

    private void notifyBloodmoonStart(ServerPlayerEntity player) {
        player.field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(SoundEvents.field_193782_bq, SoundCategory.NEUTRAL, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 1.0f, 1.0f));
    }

    private void notifyBloodmoonEnd(ServerPlayerEntity player) {
        player.func_145747_a(TEXT_BLOODMOON_FALL, Util.field_240973_b_);
        player.field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(ModSounds.RELAXED_2, SoundCategory.NEUTRAL, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 1.0f, 1.0f));
    }
}

